| package |
package := Package name: 'AIDA System Changes'.
package paxVersion: 1;
	basicComment: ''.


package classNames
	add: #AIDAInstallSysChanges;
	yourself.

package methodNames
	add: #Collection -> #allDailyCollectionDated:;
	add: #Collection -> #allDailyCollectionDates;
	add: #Collection -> #allDailyCollectionDays;
	add: #Collection -> #allDailyCollectionEntries;
	add: #Collection -> #allDailyCollectionFromDate:to:;
	add: #Collection -> #allDailyCollectionYear:;
	add: #Collection -> #allDailyCollectionYears;
	add: #Collection -> #allDailyCollectionYearsForKindOf:;
	add: #Collection -> #contains:;
	add: #Collection -> #isWebElement;
	add: #Collection -> #isWebPage;
	add: #Collection -> #printHTMLPageOn:forSession:;
	add: #Date -> #-;
	add: #Date -> #+;
	add: #Date -> #>;
	add: #Date -> #dayOfYear;
	add: #Date -> #daysInMonth;
	add: #Date -> #monthAndDayString;
	add: #Date -> #shorterPrintSloString;
	add: #Date -> #shortPrintSloString;
	add: #Date -> #shortPrintString;
	add: #Date -> #sloMonthName;
	add: #Date -> #sloWeekday;
	add: #Number -> #asFixedPoint:;
	add: #Number -> #printDotString;
	add: #Number -> #withZeros;
	add: #Object -> #aidaCanBeLocked;
	add: #Object -> #aidaDontCache;
	add: #Object -> #aidaIsLocked;
	add: #Object -> #aidaLock;
	add: #Object -> #aidaUnlock;
	add: #Object -> #contentType;
	add: #Object -> #expiresTimestamp;
	add: #Object -> #isVersionedObject;
	add: #Object -> #isWebApplication;
	add: #Object -> #isWebStyle;
	add: #Object -> #modifiedTimestamp;
	add: #Object -> #notEmpty;
	add: #Object -> #preferedUrl;
	add: #Object -> #printWebAppNotFoundFor:;
	add: #Object -> #printWebPageFor:;
	add: #Object -> #sendOver:;
	add: #Object -> #webAppFor:;
	add: #PositionableStream -> #bcrlf;
	add: #PositionableStream -> #insensitivePeekForAll:;
	add: #PositionableStream -> #insensitiveSkipThroughAll:;
	add: #PositionableStream -> #insensitiveUpToAll:;
	add: #PositionableStream -> #peekForAll:;
	add: #PositionableStream -> #readLimit;
	add: #PositionableStream -> #upToSeparator;
	add: #SequenceableCollection -> #copyUpTo:;
	add: #Stream -> #lf;
	add: #Stream -> #upTo:escaper:;
	add: #String -> #asCollectionOfHtmlHeadings;
	add: #String -> #asDouble;
	add: #String -> #asFixedPoint:;
	add: #String -> #asFloat;
	add: #String -> #asInteger;
	add: #String -> #asSloveneWithoutCircumflexes;
	add: #String -> #asWikiExceptLinksHtml;
	add: #String -> #asWikiHtml;
	add: #String -> #asWikiLinksOnlyHtml;
	add: #String -> #containsSubstring:;
	add: #String -> #convertToSloveneChars;
	add: #String -> #ensureUnicodeSloveneChars;
	add: #String -> #isValidEMailAddress;
	add: #String -> #lineCount;
	add: #String -> #lineCount:;
	add: #String -> #plainEMailAddress;
	add: #String -> #sendOver:;
	add: #String -> #shortPrintSloString;
	add: #String -> #trimNewlines;
	add: #String -> #withHeadingAnchors;
	add: #String -> #withHtmlBreaks;
	add: #String -> #withoutHtmlTags;
	add: #Time -> #printSloString;
	add: #Timestamp -> #asDate;
	add: #Timestamp -> #asSeconds;
	add: #Timestamp -> #asTime;
	add: #Timestamp -> #printSloString;
	add: #Timestamp -> #sendOver:;
	add: 'SortedCollection class' -> #withAll:sortBlock:;
	add: 'Timestamp class' -> #fromSeconds:;
	yourself.

package binaryGlobalNames: (Set new
	yourself).

package globalAliases: (Set new
	yourself).

package setPrerequisites: (IdentitySet new
	add: 'AIDA core';
	add: 'AIDA support';
	add: '..\Object Arts\Dolphin\Base\Dolphin';
	add: '..\Swazoo\Swazoo-Platform-Dolphin';
	yourself).

package!

"Class Definitions"!

Object subclass: #AIDAInstallSysChanges
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!

"Global Aliases"!


"Loose Methods"!

!Collection methodsFor!

allDailyCollectionDated: aDate
	"all on that date in any of daily collections"
	^self inject: OrderedCollection new into: [:col :each | col addAll: (each allDated: aDate). col]

"DailyCollection allInstances allDailyCollectionDated: 
		DailyCollection allInstances allDailyCollectionDates asOrderedCollection last."!

allDailyCollectionDates
	"all dates which occur of any of daily collections"
	^self allDailyCollectionDays collect: [:each | Date fromDays: each].

"DailyCollection allInstances allDailyCollectionDates"!

allDailyCollectionDays
	"all day numbers which occur of any of daily collections"
	^self inject: Set new into: [:set :each | set addAll: each allDays. set].

"DailyCollection allInstances allDailyCollectionDays"!

allDailyCollectionEntries
	"sorted by date"
	| days |
	days := self allDailyCollectionDays.
	days := days asSortedCollection. 
	^days inject: OrderedCollection new into: [:col :day | 
		self do: [:daily | (daily days includesKey: day) ifTrue: [col addAll: (daily days at: day)] ].
		col].

"DailyCollection allInstances allDailyCollectionEntries"!

allDailyCollectionFromDate: aStartDate to: anEndDate
	"sorted by date"
	| startDay endDay daysInRange |
	startDay := aStartDate asDays. endDay := anEndDate asDays.
	daysInRange := self allDailyCollectionDays select: [:each | each >= startDay and: [each <= endDay] ].
	daysInRange := daysInRange asSortedCollection. 
	^daysInRange inject: OrderedCollection new into: [:col :day | 
		self do: [:daily | (daily days includesKey: day) ifTrue: [col addAll: (daily days at: day)] ].
		col].

"DailyCollection allInstances allDailyCollectionFromDate: (Date readSloFrom: '1.1.2004' readStream) 
  	to: (Date readSloFrom: '31.12.2006' readStream)"!

allDailyCollectionYear: aNumber
	^self 
		allDailyCollectionFromDate: (Date newDay: 1 monthNumber: 1 year: aNumber)
		to: (Date newDay: 31 monthNumber: 12 year: aNumber)

"DailyCollection allInstances allDailyCollectionYear: 2004 "!

allDailyCollectionYears
	"all years on which occur of anything of daily collections. Sorted!!"
	^SortedCollection 
		withAll: (self allDailyCollectionDates inject: Set new into: [:set :each | set add: each year. set])
		sortBlock: [:a :b | a < b].

"DailyCollection allInstances allDailyCollectionYears"!

allDailyCollectionYearsForKindOf: aClass
	"all years on which occur of anything of that class. Sorted!!"
	"optimize that!!"
	^(self inject: Set new into: [:set :each | set addAll: (each allYearsForKindOf: aClass). set])
		asSortedCollection

"DailyCollection allInstances allDailyCollectionYearsForKindOf: AIDA.Invoice"!

contains: aBlock 
	"Evaluate aBlock with each of the receiver's elements as the argument.
	 Answer true if aBlock ever evaluates to true, otherwise answer false."

	self detect: aBlock ifNone: [^false].
	^true!

isWebElement
	^true "more or less"!

isWebPage
	^false!

printHTMLPageOn: aStream forSession: aSession
	"only inner html, for ajax element updates"
	self do: [:element | 
		element notNil ifTrue: [element printHTMLPageOn: aStream forSession: aSession] ].! !
!Collection categoriesFor: #allDailyCollectionDated:!daily collections!private! !
!Collection categoriesFor: #allDailyCollectionDates!daily collections!private! !
!Collection categoriesFor: #allDailyCollectionDays!daily collections!private! !
!Collection categoriesFor: #allDailyCollectionEntries!daily collections!private! !
!Collection categoriesFor: #allDailyCollectionFromDate:to:!daily collections!private! !
!Collection categoriesFor: #allDailyCollectionYear:!daily collections!private! !
!Collection categoriesFor: #allDailyCollectionYears!daily collections!private! !
!Collection categoriesFor: #allDailyCollectionYearsForKindOf:!daily collections!private! !
!Collection categoriesFor: #contains:!public!searching! !
!Collection categoriesFor: #isWebElement!AIDA web!private! !
!Collection categoriesFor: #isWebPage!AIDA web!private! !
!Collection categoriesFor: #printHTMLPageOn:forSession:!AIDA web!private! !

!Date methodsFor!

- aNumber 

	"Janko Mivsek, dec97"
	"subtract number of days from a date."

	^self subtractDays: aNumber!

+ aNumber 

	"Janko Mivsek, dec97"
	"add one day to a date."

	^self addDays: aNumber!

> aDate 
	"Janko Mivsek, apr98"
	"Answer whether the argument, aDate, is after  the date of the 
	receiver. "

	self year = aDate year
		ifTrue: [^self day > aDate day]
		ifFalse: [^self year > aDate year]!

dayOfYear
	"Answer the day of the year represented by the receiver."

	^self day!

daysInMonth
	^Date daysInMonthIndex: self monthIndex forYear: self year

"Date today daysInMonth"
!

monthAndDayString
	"with leading zeros, example: 05-16 for 16may"
	^(self monthIndex < 10 ifTrue: ['0'] ifFalse: ['']), self monthIndex printString, '-',
	 	(self dayOfMonth < 10 ifTrue: ['0'] ifFalse: ['']), self dayOfMonth printString

"Date today monthAndDayString"!

shorterPrintSloString
	"year in two digits only"
	| yeart |
	yeart := (self year \\ 100) printString. yeart size = 1 ifTrue: [yeart := '0', yeart].
	^self dayOfMonth printString, '.', self monthIndex printString, '.', yeart.

"Date today shorterPrintSloString"!

shortPrintSloString
	^self dayOfMonth printString, '.', self monthIndex printString, '.', self year printString.

"Date today shortPrintSloString   "!

shortPrintString
	"Append to the argument aStream a sequence of characters that 
	identifies the receiver."

	| aStream |
	aStream := WriteStream on: (String new: 16).
	aStream policy dateAndTimePolicy printShort: self on: aStream.
	^aStream contents!

sloMonthName
	"Answer the name of the month in which the receiver falls."

	^self monthName

"Date today sloMonthName"!

sloWeekday
	"Answer the name of the day of the week in Slovene language"

	| wday |
	wday := self weekday.
	wday = #Monday ifTrue: [^#Ponedeljek].
	wday = #Tuesday ifTrue: [^#Torek].
	wday = #Wednesday ifTrue: [^#Sreda].
	wday = #Thursday ifTrue: [^#Cetrtek].
	wday = #Friday ifTrue: [^#Petek].
	wday = #Saturday ifTrue: [^#Sobota].
	wday = #Sunday ifTrue: [^#Nedelja].

"Date today sloWeekday"! !
!Date categoriesFor: #-!arithmetic!private! !
!Date categoriesFor: #+!arithmetic!private! !
!Date categoriesFor: #>!comparing!private! !
!Date categoriesFor: #dayOfYear!inquiries!private! !
!Date categoriesFor: #daysInMonth!accessing!public! !
!Date categoriesFor: #monthAndDayString!accessing!private! !
!Date categoriesFor: #shorterPrintSloString!printing!private! !
!Date categoriesFor: #shortPrintSloString!printing!private! !
!Date categoriesFor: #shortPrintString!printing!private! !
!Date categoriesFor: #sloMonthName!accessing!private! !
!Date categoriesFor: #sloWeekday!accessing!private! !

!Number methodsFor!

asFixedPoint: scale
	"VW compatibility"
	"Answer a <FixedPoint> number, with the fractional precision 
	specified by the <integer>, scale, which most nearly approximates
	the receiver."

	^FixedPoint
		newFromNumber: self
		scale: scale
!

printDotString

	"Janko Mivsek, 1997"
	"format and return the number with dots between thousandths:  '3.120.123' "

	| mrds millions thousanths rest text number |
	number := self abs.
	mrds := number // 1000000000.
	millions := (number \\ 1000000000)  // 1000000.
	thousanths := (number \\ 1000000) // 1000.
	rest := (number \\ 1000).
	text := ''.
	mrds > 0 ifTrue: 
		[text := mrds printString, '.', (millions withZeros), '.', 
		(thousanths withZeros), '.', (rest withZeros).
		^text].
	millions > 0 	ifTrue: 
		[text := millions printString, '.', 
		(thousanths withZeros), '.', (rest withZeros).
		^text].
	thousanths > 0 
		ifTrue: 
			[text := thousanths printString, '.', 
			(rest withZeros)]
		ifFalse: [text := rest printString].
	^(self < 0 ifTrue: ['- '] ifFalse: ['']), text

"
-123 printDotString  '- 123'
"!

withZeros

	"return three digit number with leading zeros"

	^(self < 100 ifTrue: ['0'] ifFalse: ['']), 
	(self < 10 ifTrue: ['0'] ifFalse: ['']), 
	self printString.! !
!Number categoriesFor: #asFixedPoint:!converting!public! !
!Number categoriesFor: #printDotString!printing!private! !
!Number categoriesFor: #withZeros!printing!private! !

!Object methodsFor!

aidaCanBeLocked
	"can we get an exclusive lock on that object (not already locked)?"
	^false!

aidaDontCache
	"don't cache web content in a browser. Appropriate header is added to http response"
	^false!

aidaIsLocked
	"is object locked exclusively?"
	^false!

aidaLock
	"get an exclusive lock on that object. Until unlocked, noon else can get that lock. Return false if already locked, true if successfull"
	^false!

aidaUnlock
	"release an exclusive lock if any"
	^true!

contentType

	"Janko Mivsek, apr98"
	"return 'text/html' as content type for web pages"

	^'text/html'!

expiresTimestamp
	"until when content of this object wont be changed"
	"used in http response, override if you like to be included"
	^self modifiedTimestamp  "to reload pages immediately"!

isVersionedObject
	^false!

isWebApplication
	^false!

isWebStyle
	^false!

modifiedTimestamp
	"when this object was last modified"
	"used in http response, override if you like to be included"
	^nil!

notEmpty
	" Private.  GBS.  Answer true if the receiver contains at least one element.
	   NOTE:  This really belongs in class Collection, but it conflicts with the ENVY method of the same name. "

	^ self isEmpty not!

preferedUrl
	"override with a suggestion for url of this method!! If not already used, 
	it will be considered by URLResolver during automatic url generation"
	^nil!

printWebAppNotFoundFor: aSession 
	| page |
	page := WebPage new.
	page addText: 'Cannot find aWebApplication for object a', self class name.
	^page!

printWebPageFor: aSession 
	"find appropriate web application to represent self as web page"

	| webApp |
	webApp := self webAppFor: aSession.
	^webApp notNil 
		ifTrue: [webApp printWebPage]
		ifFalse: [self printWebAppNotFoundFor: aSession]!

sendOver: aStream 
	"from Wiki rendering"
	self printOn: aStream!

webAppFor: aSession
	| webApp |
	webApp := aSession webAppFor: self.
	webApp notNil ifTrue: [^webApp].
	webApp := WebApplication newFor: self on: aSession.
	webApp notNil ifTrue: [aSession addWebApp: webApp for: self].
	^webApp! !
!Object categoriesFor: #aidaCanBeLocked!AIDA web-locks!private! !
!Object categoriesFor: #aidaDontCache!AIDA web!private! !
!Object categoriesFor: #aidaIsLocked!AIDA web-locks!private! !
!Object categoriesFor: #aidaLock!AIDA web-locks!private! !
!Object categoriesFor: #aidaUnlock!AIDA web-locks!private! !
!Object categoriesFor: #contentType!AIDA web!private! !
!Object categoriesFor: #expiresTimestamp!AIDA web!private! !
!Object categoriesFor: #isVersionedObject!AIDA web!private! !
!Object categoriesFor: #isWebApplication!AIDA web!private! !
!Object categoriesFor: #isWebStyle!AIDA web!private! !
!Object categoriesFor: #modifiedTimestamp!AIDA web!private! !
!Object categoriesFor: #notEmpty!private!testing! !
!Object categoriesFor: #preferedUrl!AIDA web!private! !
!Object categoriesFor: #printWebAppNotFoundFor:!AIDA web!private! !
!Object categoriesFor: #printWebPageFor:!AIDA web!private! !
!Object categoriesFor: #sendOver:!printing!private! !
!Object categoriesFor: #webAppFor:!AIDA web!private! !

!PositionableStream methodsFor!

bcrlf

	"Janko Mivsek, Oct1996"
	"write to a stream binary codes for CR and LF"

	self nextPut: (Character cr) asInteger.
	self nextPut: (Character lf) asInteger.!

insensitivePeekForAll: aCollection 
	| orig |
	self atEnd ifTrue: [^false].
	orig := self position.
	((self nextAvailable: aCollection size) sameAs: aCollection) 
		ifTrue: [^true].
	self position: orig.
	^false!

insensitiveSkipThroughAll: aCollection 
	| first length |
	(length := aCollection size) = 0 ifTrue: [^self].
	first := aCollection at: 1.
	[self atEnd] whileFalse: 
			[(self next sameAs: first) 
				ifTrue: 
					[| nonMatch |
					nonMatch := 2.
					
					[nonMatch > length ifTrue: [^self	"Success."].
					self atEnd ifTrue: [^nil].	"Not found."
					self next sameAs: (aCollection at: nonMatch)] 
							whileTrue: [nonMatch := nonMatch + 1].
					self skip: 1 - nonMatch	"Didn't match, back up."]].
	^nil	"Not found."!

insensitiveUpToAll: aCollection 
	| first length newStream |
	(length := aCollection size) = 0 ifTrue: [^self].
	first := aCollection at: 1.
	newStream := (self contentsSpecies new: 64) writeStream.
	[self atEnd] whileFalse: 
			[| element |
			element := self next.
			(element sameAs: first) 
				ifTrue: 
					[| nonMatch |
					nonMatch := 2.
					
					[nonMatch > length ifTrue: [^newStream contents	"Success."].
					self atEnd 
						ifTrue: 
							[1 to: nonMatch - 1 do: [:i | newStream nextPut: (aCollection at: i)].
							^newStream contents	"Not found."].
					self next sameAs: (aCollection at: nonMatch)] 
							whileTrue: [nonMatch := nonMatch + 1].
					self skip: 1 - nonMatch	"Didn't match, back up."].
			newStream nextPut: element].
	^newStream contents	"Not found."!

peekForAll: aCollection 
	| orig |
	self atEnd ifTrue: [^false].
	orig := self position.
	(self nextAvailable: aCollection size) = aCollection ifTrue: [^true].
	self position: orig.
	^false!

readLimit
	^readLimit!

upToSeparator
	"Answer a subcollection from position to the occurrence (if any, exclusive) of a separator.
	The stream is left positioned after the separator.
	If no separator is found answer everything."

	| newStream element |
	newStream := (String new: 64) writeStream.
	[self atEnd]
		whileFalse:
			[element := self next.
			element isSeparator
				ifTrue: [^newStream contents].
			newStream nextPut: element.].
	^newStream contents

" '123 456' readStream upToSeparator"! !
!PositionableStream categoriesFor: #bcrlf!constants!private! !
!PositionableStream categoriesFor: #insensitivePeekForAll:!positioning!private! !
!PositionableStream categoriesFor: #insensitiveSkipThroughAll:!positioning!private! !
!PositionableStream categoriesFor: #insensitiveUpToAll:!positioning!private! !
!PositionableStream categoriesFor: #peekForAll:!positioning!private! !
!PositionableStream categoriesFor: #readLimit!accessing!private! !
!PositionableStream categoriesFor: #upToSeparator!positioning!public! !

!SequenceableCollection methodsFor!

copyUpTo: anObject
	"Answer a copy of the receiver from index 1 to the first occurrence of 
	anObject, non-inclusive."

	| index |
	index := self indexOf: anObject ifAbsent: [^self copy].
	^self copyFrom: 1 to: index-1! !
!SequenceableCollection categoriesFor: #copyUpTo:!copying!public! !

!SortedCollection class methodsFor!

withAll: aCollection sortBlock: aBlock
	" Answer a new SortedCollection with
	the given elements and sortBlock. "

	| newCollection |
	newCollection := self new: aCollection size.
	newCollection sortBlock: aBlock.
	newCollection addAll: aCollection.
	^newCollection! !
!SortedCollection class categoriesFor: #withAll:sortBlock:!instance creation!public! !

!Stream methodsFor!

lf
	"Janko Mivsek"
	"Append a linefeed character to the receiver."

	self nextPut: Character lf!

upTo: anObject escaper: anotherObject 
	"from WikiWorks"
	| newStream |
	newStream := (self contentsSpecies new: 64) writeStream.
	[self atEnd] whileFalse: 
			[| element |
			(element := self next) = anotherObject 
				ifTrue: 
					[newStream nextPut: ((self peekFor: anObject) 
								ifTrue: [anObject]
								ifFalse: [anotherObject])]
				ifFalse: 
					[element = anObject ifTrue: [^newStream contents].
					newStream nextPut: element]].
	^newStream contents! !
!Stream categoriesFor: #lf!character writing!private! !
!Stream categoriesFor: #upTo:escaper:!accessing!private! !

!String methodsFor!

asCollectionOfHtmlHeadings
	"find all headings H1-5 and return a collection of headings, complete with tags"
	| in tag collection line |
	in := self readStream. collection := OrderedCollection new.
	[in atEnd] whileFalse:
		[in upTo: $<. in atEnd ifFalse: [tag := in upTo: $>].
		(tag size >= 2 and: [tag first asLowercase = $h and: [(tag at: 2) isDigit]] ) ifTrue:
			[line := '<', tag, '>', (in upTo: $<), '</', tag, '>'. in upTo: $>.
			collection add: line] ].
	^collection

"'<h1>Heading1</h1><h2>Heading2</h2>' asCollectionOfHtmlHeadings"!

asDouble

	"Janko Mivsek, TRIS A d.o.o. dec97"
	"convert a string to a double precision floating point number"

	| clean pos exponent result sign |
	sign := self detect: [:ch | ch = $- | ch isDigit].
	sign = $- ifTrue: [sign := -1] ifFalse: [sign := 1].
	clean := self select: [:ch | ch isDigit | (ch = $,)].
	pos := clean indexOf: $,.
	pos = 0 
		ifTrue: [result := clean asInteger asFloat]
		ifFalse: 
			[exponent := pos - 2.
			clean := clean select: [:ch | ch isDigit].
			result := 0.0d.
			clean do: [:digit | 
				result := result + ((digit asInteger - $0 asInteger) * (10**exponent)).
				exponent := exponent - 1]].
	^result * sign
"
'-2.445.444,988899987' asDouble 
"!

asFixedPoint: aScaleNumber

	"Janko Mivsek, TRIS A d.o.o. dec97"
	"convert a string to a fixed point number with specified scale. Precision is remained as specified
	in fraction part of a number"

	| clean pos sign number |
	self isEmpty ifTrue: [^0 asFixedPoint: aScaleNumber].
	sign := self detect: [:ch | ch = $- | ch isDigit].
	sign = $- ifTrue: [sign := -1] ifFalse: [sign := 1].
	clean := self select: [:ch | ch isDigit | (ch = $,)].
	clean isEmpty ifTrue: [^0.0s].
	clean first = $, ifTrue: [clean := '0', clean].
	pos := clean indexOf: $,.
	pos = 0 
		ifTrue: [number := clean asInteger asFixedPoint: aScaleNumber]
		ifFalse: 
			[number := FixedPoint
				numerator: clean asInteger
				denominator: 10**(clean size - pos)
				scale: aScaleNumber].
	^number * sign

"
'-2.445.444,988899987' asFixedPoint: 2
"!

asFloat

	"Janko Mivsek, TRIS A d.o.o. dec97"
	"convert a string to a floating point number"

	| clean pos exponent result sign |
	sign := self detect: [:ch | ch = $- | ch isDigit].
	sign = $- ifTrue: [sign := -1] ifFalse: [sign := 1].
	clean := self select: [:ch | ch isDigit | (ch = $,)].
	pos := clean indexOf: $,.
	pos = 0 
		ifTrue: [result := clean asInteger asFloat]
		ifFalse: 
			[exponent := pos - 2.
			clean := clean select: [:ch | ch isDigit].
			result := 0.0.
			clean do: [:digit | 
				result := result + ((digit asInteger - $0 asInteger) * (10**exponent)).
				exponent := exponent - 1]].
	^result * sign
"
'-24,9' asFloat
"!

asInteger

	"Janko Mivsek, TRIS A d.o.o. sep96"
	"convert a string to an integer number"

	| number sign |
	self isEmpty ifTrue: [^0].
	sign := self detect: [:ch | ch = $- | ch isDigit] ifNone: [$+].
	sign = $- ifTrue: [sign := -1] ifFalse: [sign := 1].
	number := 0.
	self do: [:char | char isDigit ifTrue: 
		[number := number * 10.
		number := number + (char asInteger - $0 asInteger)]].
	^number * sign

"
' ' asInteger
"!

asSloveneWithoutCircumflexes
	"convert Unicode csz string with ^ (sumniki) to plain ascii csz"
	"'c^s^z^C^S^Z^' convertToSloveneChars asSloveneWithoutCircumflexes"
	^self collect: 
		[:ch | ch asInteger > 127 
			ifTrue:
				[ch = AIDASite charc ifTrue: [$c]
					ifFalse: [ ch  = AIDASite charC ifTrue: [$C]
					ifFalse: [ ch  = AIDASite chars ifTrue: [$s]
					ifFalse: [ ch  = AIDASite charS ifTrue: [$S]
					ifFalse: [ ch  = AIDASite charz ifTrue: [$z] 
					ifFalse: [ ch  = AIDASite charZ ifTrue: [$Z]
					ifFalse: [$- ] ]]]]]
				]
			ifFalse: [ch] ]!

asWikiExceptLinksHtml
	"render this string in Wiki format (leave links in square brackets intact) and return Html"
	^WikiRender exceptLinksFrom: self!

asWikiHtml
	"render this string in Wiki format and return Html"
	^WikiRender from: self!

asWikiLinksOnlyHtml
	"render this string in Wiki format (links in square brackets only) and return Html"
	^WikiRender linksOnlyFrom: self!

containsSubstring: aString
	^(self 
		indexOfSubCollection: aString 
		startingAt: 1) > 0!

convertToSloveneChars
	"convert csz string with ^ as 'sumnik' to proper unicode string"
	"'Mivs^ek' convertToSloveneChars"
	| in out ch |
	in := self readStream. out := WriteStream on: String new.
	[in atEnd] whileFalse: 
		[ch := in next.
		(in peek = $^ ) ifTrue: [(#($c $C $s $S $z $Z) includes: ch) ifTrue: 
			[in next. 
			ch = $c ifTrue: [ch := AIDASite charc]. ch = $C ifTrue: [ch := AIDASite charC].
			ch = $s ifTrue: [ch := AIDASite chars]. 	ch = $S ifTrue: [ch := AIDASite charS].
			ch = $z ifTrue: [ch := AIDASite charz]. ch = $Z ifTrue: [ch := AIDASite charZ] ] ].
		out nextPut: ch].
	^out contents!

ensureUnicodeSloveneChars
	"if string has other that unicode slovene chars, try to correct them!!"
	"'Miv©ek' ensureUnicodeSloveneChars"
	| in out ch uniSet |
	in := self readStream. out := WriteStream on: String new. uniSet := AIDASite charCszSet. 
	[in atEnd] whileFalse: 
		[ch := in next.
		(ch asInteger < 128 or: [uniSet includes: ch])
			ifTrue: [out nextPut: ch]
			ifFalse: [out nextPut: 
				([(AIDASite convert: (String with: ch) fromCodepage: #'iso-8859-2') first]
					on: Error do: [:ex | ch]) ] ].
	^out contents!

isValidEMailAddress
	(self includes: $@) ifFalse: [^false].
	^(self trimBlanks contains: [:char | 
		char isAlphaNumeric not and: [(#($. $- $_  $@) includes: char) not] ]) not

" 'janko.mivsek@eranova.si' isValidEMailAddress"!

lineCount
	^(self occurrencesOf: Character cr) + 1!

lineCount: aNumber
	"count lines, consider breaks too if line is longer than aNumber chars"
	^self asArrayOfLines inject: 0 into: [:sum :each | sum + (each size // aNumber + 1) ]

"'12345 789 12345' lineCount: 10"
"'12345 789' lineCount: 10"!

plainEMailAddress
	"only plain email address, see example below"
	^(self includes: $<) 
		ifTrue: [self readStream upTo: $<; upTo: $>]
		ifFalse: [self].
	
" 'Janko Mivsek <janko.mivsek@eranova.si>' cleanEMailAddress"!

sendOver: aStream 
	"from Wiki rendering"
	aStream nextPutAll: self!

shortPrintSloString
	^self!

trimNewlines
	"replace new lines with space"
	| in out |
	in := self readStream.
	out := WriteStream on: String new.
	[in atEnd] whileFalse:
		[out nextPutAll: (in upTo: Character cr).
		in atEnd ifFalse: [in peek = Character cr ifTrue: [in upTo: Character cr] ].
		out nextPut: $  ].
	^out contents

" 'y Michael A. <br>Prospero</span>' withoutHtmlTags trimNewlines "!

withHeadingAnchors
	"add anchors before all H1-5 tags, each with sequence number of that tag, eg: <a name=h-15>"
	| in out tag number |
	in := self readStream. number := 1.
	out := WriteStream on: String new.
	[in atEnd] whileFalse:
		[out nextPutAll: (in upTo: $<).
		in atEnd ifFalse: [tag := in upTo: $>] ifTrue: [tag := nil].
		(tag size = 2 and: [tag first asLowercase = $h and: [tag last isDigit]] ) ifTrue:
			[out nextPutAll: '<a name="h-', number printString, '">'. 
			number := number +1].
		tag notNil ifTrue: [out nextPutAll: '<', tag, '>']].
	^out contents

"'<h1>Heading1</h1><h2>Heading2</h2>' withHeadingAnchors"!

withHtmlBreaks
	"changes all cr with <br>"
	^self copyReplaceAll: (String with: Character cr) with: '<br>'

"('aaa', (String with: Character cr), 'bbb') withHtmlBreaks"!

withoutHtmlTags
	"strip all tags, replace <br> and <p> with cr"
	| in out tag |
	in := self readStream.
	out := WriteStream on: String new.
	[in atEnd] whileFalse:
		[out nextPutAll: (in upTo: $<).
		in atEnd ifFalse: [tag := in upTo: $>].
		(tag = 'br') | (tag = 'p') ifTrue: [out nextPut: Character cr ] ].
	^out contents

"'<span>by Michael A. <br>Prospero</span>' withoutHtmlTags"! !
!String categoriesFor: #asCollectionOfHtmlHeadings!converting!private! !
!String categoriesFor: #asDouble!converting!private! !
!String categoriesFor: #asFixedPoint:!converting!private! !
!String categoriesFor: #asFloat!converting!private! !
!String categoriesFor: #asInteger!converting!private! !
!String categoriesFor: #asSloveneWithoutCircumflexes!converting!private! !
!String categoriesFor: #asWikiExceptLinksHtml!converting!private! !
!String categoriesFor: #asWikiHtml!converting!private! !
!String categoriesFor: #asWikiLinksOnlyHtml!converting!private! !
!String categoriesFor: #containsSubstring:!private!testing! !
!String categoriesFor: #convertToSloveneChars!converting!private! !
!String categoriesFor: #ensureUnicodeSloveneChars!converting!private! !
!String categoriesFor: #isValidEMailAddress!private!testing! !
!String categoriesFor: #lineCount!accessing!private! !
!String categoriesFor: #lineCount:!accessing!private! !
!String categoriesFor: #plainEMailAddress!converting!private! !
!String categoriesFor: #sendOver:!printing!private! !
!String categoriesFor: #shortPrintSloString!converting!private! !
!String categoriesFor: #trimNewlines!converting!private! !
!String categoriesFor: #withHeadingAnchors!converting!private! !
!String categoriesFor: #withHtmlBreaks!converting!private! !
!String categoriesFor: #withoutHtmlTags!converting!private! !

!Time methodsFor!

printSloString
	^"(self hours < 10 ifTrue: ['0'] ifFalse: [''])," self hours printString, ':',
		(self minutes < 10 ifTrue: ['0'] ifFalse: ['']), self minutes printString

"Time now printSloString"! !
!Time categoriesFor: #printSloString!printing!private! !

!Timestamp methodsFor!

asDate
	^self date
!

asSeconds
	^self date asSeconds + self time asSeconds

"Timestamp now asSeconds"!

asTime
	^self time
!

printSloString
	^self date shortPrintSloString, ' ', self time printSloString

"Timestamp now printSloString"!

sendOver: aStream 
	"from Wiki rendering"
	aStream nextPutAll: self printString
! !
!Timestamp categoriesFor: #asDate!printing!public! !
!Timestamp categoriesFor: #asSeconds!printing!public! !
!Timestamp categoriesFor: #asTime!printing!public! !
!Timestamp categoriesFor: #printSloString!printing!private! !
!Timestamp categoriesFor: #sendOver:!printing!private! !

!Timestamp class methodsFor!

fromSeconds: aNumber
	| ts |
	ts := TimeStamp fromSeconds: aNumber .
	^self new initializeWithDate: ts date time: ts time! !
!Timestamp class categoriesFor: #fromSeconds:!public! !

"End of package definition"!

"Source Globals"!

"Classes"!

AIDAInstallSysChanges guid: (GUID fromString: '{EE6A91EA-1A2F-4580-B131-AD5DA1FBEFBC}')!
AIDAInstallSysChanges comment: ''!
!AIDAInstallSysChanges categoriesForClass!Unclassified! !
"Binary Globals"!

